package org.pgusb.usb4allLib;

import exceptions.Usb4allException;

public class SteperMotorISR extends Usb4allDevice {

	//skeleton
	private static final int IN_ENDPOINT_TYPE = Usb4allDevice.BULK_IN; //Replace with the prefered In Endpoint Type.
	private static final int OUT_ENDPOINT_TYPE = Usb4allDevice.BULK_OUT; //Replace with the prefered Out Endpoint Type.
	
	public SteperMotorISR(String moduleName){
		super(IN_ENDPOINT_TYPE,OUT_ENDPOINT_TYPE);
		this.moduleName=moduleName;
	}
	
	public SteperMotorISR(){
		super(IN_ENDPOINT_TYPE,OUT_ENDPOINT_TYPE);
		moduleName="motorin"; //Put the name of the firmware module.
	}

	public int getVersion(){
		byte[] command = new byte[1];
		byte[] version = null;
		command[0]=0x00;
		try {
			send(command);
			version = receive(4);
		} catch (Usb4allException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		System.out.println("La version es:" +" "+ version[0] +  " "+ version[1] +" "+ version[2] +" "+ version[3]);
		return 1;
	}

	public void stop(){
		byte[] command = new byte[2];
		byte[] respuesta = new byte[1];
		command[0]=0x01;
		command[1]=0;
		try {
			send(command);
			respuesta = receive(1);
			System.out.println(respuesta[0]);
		} catch (Usb4allException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	public void rotateRight(){
		byte[] command = new byte[2];
		command[0]=0x01;
		command[1]=0x01;
		byte[] respuesta = new byte[1];
		try {
			send(command);
			respuesta = receive(1);
			System.out.println(respuesta[0]);
		} catch (Usb4allException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	public void rotateLeft(){
		byte[] command = new byte[2];
		byte[] respuesta = new byte[1];
		command[0]=0x01;
		command[1]=0x02;
		try {
			send(command);
			respuesta = receive(1);
			System.out.println(respuesta[0]);
		} catch (Usb4allException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	public void mover(byte sentido, short steps){
		byte[] commandSentido = new byte[2];
		byte[] commandPasos   = new byte[3];
		commandSentido[0]=0x01;
		commandSentido[1]=sentido;
		commandPasos[0]=0x03;
		commandPasos[1]=(byte) (steps % 256);
		commandPasos[2]=(byte) (steps / 256);
		try {
			send(commandPasos);
			receive(1);
			send(commandSentido);
			receive(1);
		} catch (Usb4allException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	public void setVel(short vel){
		byte[] command = new byte[3];
		command[0]=0x02;
		command[1]=(byte) (vel % 256);
		command[2]=(byte) (vel / 256);
		try {
			send(command);
			receive(1);
		} catch (Usb4allException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	public void setSteps(short steps){
		byte[] command = new byte[3];
		command[0]=0x03;
		command[1]=(byte) (steps % 256);
		command[2]=(byte) (steps / 256);
		try {
			send(command);
			receive(1);
		} catch (Usb4allException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}	
}
